using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgBloodAvailabilitySearch
	/// </summary>
	public class DlgBloodAvailabilitySearch : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		# region Form Controls

		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpProductType;
		private System.Windows.Forms.GroupBox grpABORh;
		private System.Windows.Forms.GroupBox grpAntigens;
		private System.Windows.Forms.TabControl tabParamters;
		private System.Windows.Forms.TabPage pageProductMods;
		private System.Windows.Forms.GroupBox grpProductMods;
		private System.Windows.Forms.Button btnSelectAllProductMods;
		private System.Windows.Forms.Button btnDeselectAllProductMods;
		private System.Windows.Forms.Button btnSelectAllRestrictions;
		private System.Windows.Forms.Button btnDeselectAllRestrictions;
		private System.Windows.Forms.CheckBox cbCMVNegative;
		private System.Windows.Forms.CheckBox cbSickleCellNegative;
		private System.Windows.Forms.Label lblRBCAntigens;
		private System.Windows.Forms.TabPage pageProductType;
		private System.Windows.Forms.Button btnSelectAllProductTypes;
		private System.Windows.Forms.Button btnDeselectAllProductTypes;
		private System.Windows.Forms.TabPage pageABORh;
		private System.Windows.Forms.Button btnSelectAllABORh;
		private System.Windows.Forms.Button btnDeselectAllABORh;
		private System.Windows.Forms.TabPage pageUnitStatus;
		private System.Windows.Forms.GroupBox grpUnitStatus;
		private System.Windows.Forms.Button btnSelectAllUnitStatus;
		private System.Windows.Forms.Button btnDeselectAllUnitStatus;
		private System.Windows.Forms.TabPage pageAntigens;
		private System.Windows.Forms.Button btnSelectAllAntigens;
		private System.Windows.Forms.Button btnDeselectAllAntigens;
		private System.Windows.Forms.TextBox txtRBCAntigens;
		private System.Windows.Forms.CheckBox cbBiohazardous;
		private System.Windows.Forms.CheckBox cbQuarantined;
		private System.Windows.Forms.TabPage pageDonationType;
		private System.Windows.Forms.GroupBox grpDonationType;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.TabPage pageDateRange;
		private System.Windows.Forms.DateTimePicker dtpUntExpiresBefore;
		private System.Windows.Forms.CheckBox cbUnitExpiresBefore;
		private System.Windows.Forms.CheckBox cbUnitExpiresAfter;
		private System.Windows.Forms.DateTimePicker dtpUnitExpiresAfter;
		private System.Windows.Forms.GroupBox grpUnitExpiration;
		private System.Windows.Forms.TabPage pageDivision;
		private System.Windows.Forms.GroupBox grpDivisions;
		private System.Windows.Forms.Button btnSelectAllDivisions;
		private System.Windows.Forms.Button btnDeselectAllDivisions;
		private System.Windows.Forms.ListView divisionList;
		private System.ComponentModel.IContainer components = null;
		private System.Windows.Forms.ColumnHeader DivisionName;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ListView clbAntigens;
		private System.Windows.Forms.ListView clbProductType;
		private System.Windows.Forms.ColumnHeader ComponentClass;
		private System.Windows.Forms.ListView clbUnitStatuses;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ListView clbDonationType;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ListView clbAttributes;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.Timer timer1;
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.CheckBox cbStartDate;
		private System.Windows.Forms.CheckBox cbEndDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private System.Windows.Forms.ListView clbABORh;

		#endregion
		
		# region Constructor/Descructor

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="currentDivisionOnly"></param>
		public DlgBloodAvailabilitySearch(bool currentDivisionOnly)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			// Loading the Check Boxes into the list views.
			LoadCheckBoxes();

			if (currentDivisionOnly)
			{
				//Check user's division by default
				CheckUsersDivision();
			}
			else
			{
				CheckAllDivisions();
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgBloodAvailabilitySearch));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.tabParamters = new System.Windows.Forms.TabControl();
			this.pageProductType = new System.Windows.Forms.TabPage();
			this.grpProductType = new System.Windows.Forms.GroupBox();
			this.clbProductType = new System.Windows.Forms.ListView();
			this.ComponentClass = new System.Windows.Forms.ColumnHeader();
			this.btnSelectAllProductTypes = new System.Windows.Forms.Button();
			this.btnDeselectAllProductTypes = new System.Windows.Forms.Button();
			this.pageAntigens = new System.Windows.Forms.TabPage();
			this.grpAntigens = new System.Windows.Forms.GroupBox();
			this.clbAntigens = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.txtRBCAntigens = new System.Windows.Forms.TextBox();
			this.lblRBCAntigens = new System.Windows.Forms.Label();
			this.cbSickleCellNegative = new System.Windows.Forms.CheckBox();
			this.cbCMVNegative = new System.Windows.Forms.CheckBox();
			this.btnSelectAllAntigens = new System.Windows.Forms.Button();
			this.btnDeselectAllAntigens = new System.Windows.Forms.Button();
			this.pageDonationType = new System.Windows.Forms.TabPage();
			this.grpDonationType = new System.Windows.Forms.GroupBox();
			this.clbDonationType = new System.Windows.Forms.ListView();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.btnSelectAllRestrictions = new System.Windows.Forms.Button();
			this.btnDeselectAllRestrictions = new System.Windows.Forms.Button();
			this.pageUnitStatus = new System.Windows.Forms.TabPage();
			this.grpUnitStatus = new System.Windows.Forms.GroupBox();
			this.clbUnitStatuses = new System.Windows.Forms.ListView();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.cbBiohazardous = new System.Windows.Forms.CheckBox();
			this.cbQuarantined = new System.Windows.Forms.CheckBox();
			this.btnSelectAllUnitStatus = new System.Windows.Forms.Button();
			this.btnDeselectAllUnitStatus = new System.Windows.Forms.Button();
			this.pageDateRange = new System.Windows.Forms.TabPage();
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.cbStartDate = new System.Windows.Forms.CheckBox();
			this.cbEndDate = new System.Windows.Forms.CheckBox();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.grpUnitExpiration = new System.Windows.Forms.GroupBox();
			this.cbUnitExpiresBefore = new System.Windows.Forms.CheckBox();
			this.cbUnitExpiresAfter = new System.Windows.Forms.CheckBox();
			this.dtpUntExpiresBefore = new System.Windows.Forms.DateTimePicker();
			this.dtpUnitExpiresAfter = new System.Windows.Forms.DateTimePicker();
			this.pageABORh = new System.Windows.Forms.TabPage();
			this.grpABORh = new System.Windows.Forms.GroupBox();
			this.clbABORh = new System.Windows.Forms.ListView();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.btnSelectAllABORh = new System.Windows.Forms.Button();
			this.btnDeselectAllABORh = new System.Windows.Forms.Button();
			this.pageProductMods = new System.Windows.Forms.TabPage();
			this.grpProductMods = new System.Windows.Forms.GroupBox();
			this.clbAttributes = new System.Windows.Forms.ListView();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.btnSelectAllProductMods = new System.Windows.Forms.Button();
			this.btnDeselectAllProductMods = new System.Windows.Forms.Button();
			this.pageDivision = new System.Windows.Forms.TabPage();
			this.grpDivisions = new System.Windows.Forms.GroupBox();
			this.divisionList = new System.Windows.Forms.ListView();
			this.DivisionName = new System.Windows.Forms.ColumnHeader();
			this.btnSelectAllDivisions = new System.Windows.Forms.Button();
			this.btnDeselectAllDivisions = new System.Windows.Forms.Button();
			this.btnOK = new System.Windows.Forms.Button();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			this.grpImage.SuspendLayout();
			this.tabParamters.SuspendLayout();
			this.pageProductType.SuspendLayout();
			this.grpProductType.SuspendLayout();
			this.pageAntigens.SuspendLayout();
			this.grpAntigens.SuspendLayout();
			this.pageDonationType.SuspendLayout();
			this.grpDonationType.SuspendLayout();
			this.pageUnitStatus.SuspendLayout();
			this.grpUnitStatus.SuspendLayout();
			this.pageDateRange.SuspendLayout();
			this.grpDateRange.SuspendLayout();
			this.grpUnitExpiration.SuspendLayout();
			this.pageABORh.SuspendLayout();
			this.grpABORh.SuspendLayout();
			this.pageProductMods.SuspendLayout();
			this.grpProductMods.SuspendLayout();
			this.pageDivision.SuspendLayout();
			this.grpDivisions.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(392, 30);
			this.vbecsLogo1.TabIndex = 3;
			this.vbecsLogo1.Title = "Blood Availability Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 350);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 301);
			this.grpImage.TabIndex = 4;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(2, 16);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 38;
			this.pictureBox1.TabStop = false;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(316, 341);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// tabParamters
			// 
			this.tabParamters.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabParamters.Controls.Add(this.pageProductType);
			this.tabParamters.Controls.Add(this.pageUnitStatus);
			this.tabParamters.Controls.Add(this.pageAntigens);
			this.tabParamters.Controls.Add(this.pageDonationType);
			this.tabParamters.Controls.Add(this.pageDateRange);
			this.tabParamters.Controls.Add(this.pageABORh);
			this.tabParamters.Controls.Add(this.pageProductMods);
			this.tabParamters.Controls.Add(this.pageDivision);
			this.tabParamters.Location = new System.Drawing.Point(60, 36);
			this.tabParamters.Multiline = true;
			this.tabParamters.Name = "tabParamters";
			this.tabParamters.SelectedIndex = 0;
			this.tabParamters.Size = new System.Drawing.Size(328, 297);
			this.tabParamters.SizeMode = System.Windows.Forms.TabSizeMode.FillToRight;
			this.tabParamters.TabIndex = 0;
			// 
			// pageProductType
			// 
			this.pageProductType.Controls.Add(this.grpProductType);
			this.pageProductType.Location = new System.Drawing.Point(4, 42);
			this.pageProductType.Name = "pageProductType";
			this.pageProductType.Size = new System.Drawing.Size(320, 251);
			this.pageProductType.TabIndex = 0;
			this.pageProductType.Text = "Component Class";
			// 
			// grpProductType
			// 
			this.grpProductType.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpProductType.Controls.Add(this.clbProductType);
			this.grpProductType.Controls.Add(this.btnSelectAllProductTypes);
			this.grpProductType.Controls.Add(this.btnDeselectAllProductTypes);
			this.grpProductType.Location = new System.Drawing.Point(4, 4);
			this.grpProductType.Name = "grpProductType";
			this.grpProductType.Size = new System.Drawing.Size(312, 241);
			this.grpProductType.TabIndex = 0;
			this.grpProductType.TabStop = false;
			this.grpProductType.Text = "Component Class";
			// 
			// clbProductType
			// 
			this.clbProductType.CheckBoxes = true;
			this.clbProductType.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							 this.ComponentClass});
			this.clbProductType.FullRowSelect = true;
			this.clbProductType.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.clbProductType.HideSelection = false;
			this.clbProductType.Location = new System.Drawing.Point(8, 20);
			this.clbProductType.MultiSelect = false;
			this.clbProductType.Name = "clbProductType";
			this.clbProductType.Size = new System.Drawing.Size(300, 214);
			this.clbProductType.TabIndex = 0;
			this.clbProductType.View = System.Windows.Forms.View.Details;
			// 
			// ComponentClass
			// 
			this.ComponentClass.Text = "ComponentClass";
			this.ComponentClass.Width = 270;
			// 
			// btnSelectAllProductTypes
			// 
			this.btnSelectAllProductTypes.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllProductTypes.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllProductTypes.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllProductTypes.Image")));
			this.btnSelectAllProductTypes.Location = new System.Drawing.Point(290, 0);
			this.btnSelectAllProductTypes.Name = "btnSelectAllProductTypes";
			this.btnSelectAllProductTypes.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllProductTypes.TabIndex = 2;
			this.btnSelectAllProductTypes.Click += new System.EventHandler(this.btnSelectAll_Click);
			// 
			// btnDeselectAllProductTypes
			// 
			this.btnDeselectAllProductTypes.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllProductTypes.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllProductTypes.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllProductTypes.Image")));
			this.btnDeselectAllProductTypes.Location = new System.Drawing.Point(274, 0);
			this.btnDeselectAllProductTypes.Name = "btnDeselectAllProductTypes";
			this.btnDeselectAllProductTypes.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllProductTypes.TabIndex = 1;
			this.btnDeselectAllProductTypes.Click += new System.EventHandler(this.btnDeselectAll_Click);
			// 
			// pageAntigens
			// 
			this.pageAntigens.Controls.Add(this.grpAntigens);
			this.pageAntigens.Location = new System.Drawing.Point(4, 42);
			this.pageAntigens.Name = "pageAntigens";
			this.pageAntigens.Size = new System.Drawing.Size(320, 251);
			this.pageAntigens.TabIndex = 5;
			this.pageAntigens.Text = "Testing";
			this.pageAntigens.Visible = false;
			// 
			// grpAntigens
			// 
			this.grpAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAntigens.Controls.Add(this.clbAntigens);
			this.grpAntigens.Controls.Add(this.txtRBCAntigens);
			this.grpAntigens.Controls.Add(this.lblRBCAntigens);
			this.grpAntigens.Controls.Add(this.cbSickleCellNegative);
			this.grpAntigens.Controls.Add(this.cbCMVNegative);
			this.grpAntigens.Controls.Add(this.btnSelectAllAntigens);
			this.grpAntigens.Controls.Add(this.btnDeselectAllAntigens);
			this.grpAntigens.Location = new System.Drawing.Point(4, 4);
			this.grpAntigens.Name = "grpAntigens";
			this.grpAntigens.Size = new System.Drawing.Size(312, 242);
			this.grpAntigens.TabIndex = 0;
			this.grpAntigens.TabStop = false;
			this.grpAntigens.Text = "Testing";
			// 
			// clbAntigens
			// 
			this.clbAntigens.CheckBoxes = true;
			this.clbAntigens.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						  this.columnHeader1});
			this.clbAntigens.FullRowSelect = true;
			this.clbAntigens.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.clbAntigens.HideSelection = false;
			this.clbAntigens.Location = new System.Drawing.Point(8, 96);
			this.clbAntigens.MultiSelect = false;
			this.clbAntigens.Name = "clbAntigens";
			this.clbAntigens.Size = new System.Drawing.Size(300, 139);
			this.clbAntigens.TabIndex = 17;
			this.clbAntigens.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "AntigenType";
			this.columnHeader1.Width = 270;
			// 
			// txtRBCAntigens
			// 
			this.txtRBCAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtRBCAntigens.Location = new System.Drawing.Point(8, 76);
			this.txtRBCAntigens.Name = "txtRBCAntigens";
			this.txtRBCAntigens.Size = new System.Drawing.Size(296, 20);
			this.txtRBCAntigens.TabIndex = 2;
			this.txtRBCAntigens.Text = "";
			this.txtRBCAntigens.TextChanged += new System.EventHandler(this.txtRBCAntigens_TextChanged);
			// 
			// lblRBCAntigens
			// 
			this.lblRBCAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblRBCAntigens.Location = new System.Drawing.Point(8, 60);
			this.lblRBCAntigens.Name = "lblRBCAntigens";
			this.lblRBCAntigens.Size = new System.Drawing.Size(296, 20);
			this.lblRBCAntigens.TabIndex = 15;
			this.lblRBCAntigens.Text = "RBC Antigens";
			this.lblRBCAntigens.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cbSickleCellNegative
			// 
			this.cbSickleCellNegative.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbSickleCellNegative.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbSickleCellNegative.Location = new System.Drawing.Point(8, 40);
			this.cbSickleCellNegative.Name = "cbSickleCellNegative";
			this.cbSickleCellNegative.Size = new System.Drawing.Size(296, 20);
			this.cbSickleCellNegative.TabIndex = 1;
			this.cbSickleCellNegative.Text = "Sic&kle Cell Negative";
			// 
			// cbCMVNegative
			// 
			this.cbCMVNegative.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbCMVNegative.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbCMVNegative.Location = new System.Drawing.Point(8, 20);
			this.cbCMVNegative.Name = "cbCMVNegative";
			this.cbCMVNegative.Size = new System.Drawing.Size(296, 20);
			this.cbCMVNegative.TabIndex = 0;
			this.cbCMVNegative.Text = "CM&V Negative";
			// 
			// btnSelectAllAntigens
			// 
			this.btnSelectAllAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllAntigens.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllAntigens.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllAntigens.Image")));
			this.btnSelectAllAntigens.Location = new System.Drawing.Point(290, 0);
			this.btnSelectAllAntigens.Name = "btnSelectAllAntigens";
			this.btnSelectAllAntigens.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllAntigens.TabIndex = 5;
			this.btnSelectAllAntigens.Click += new System.EventHandler(this.btnSelectAll_Click);
			// 
			// btnDeselectAllAntigens
			// 
			this.btnDeselectAllAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllAntigens.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllAntigens.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllAntigens.Image")));
			this.btnDeselectAllAntigens.Location = new System.Drawing.Point(274, 0);
			this.btnDeselectAllAntigens.Name = "btnDeselectAllAntigens";
			this.btnDeselectAllAntigens.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllAntigens.TabIndex = 4;
			this.btnDeselectAllAntigens.Click += new System.EventHandler(this.btnDeselectAll_Click);
			// 
			// pageDonationType
			// 
			this.pageDonationType.Controls.Add(this.grpDonationType);
			this.pageDonationType.Location = new System.Drawing.Point(4, 42);
			this.pageDonationType.Name = "pageDonationType";
			this.pageDonationType.Size = new System.Drawing.Size(320, 251);
			this.pageDonationType.TabIndex = 4;
			this.pageDonationType.Text = "Donation Type";
			this.pageDonationType.Visible = false;
			// 
			// grpDonationType
			// 
			this.grpDonationType.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDonationType.Controls.Add(this.clbDonationType);
			this.grpDonationType.Controls.Add(this.btnSelectAllRestrictions);
			this.grpDonationType.Controls.Add(this.btnDeselectAllRestrictions);
			this.grpDonationType.Location = new System.Drawing.Point(4, 4);
			this.grpDonationType.Name = "grpDonationType";
			this.grpDonationType.Size = new System.Drawing.Size(312, 242);
			this.grpDonationType.TabIndex = 0;
			this.grpDonationType.TabStop = false;
			this.grpDonationType.Text = "Donation Type";
			// 
			// clbDonationType
			// 
			this.clbDonationType.CheckBoxes = true;
			this.clbDonationType.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnHeader3});
			this.clbDonationType.FullRowSelect = true;
			this.clbDonationType.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.clbDonationType.HideSelection = false;
			this.clbDonationType.Location = new System.Drawing.Point(8, 20);
			this.clbDonationType.MultiSelect = false;
			this.clbDonationType.Name = "clbDonationType";
			this.clbDonationType.Size = new System.Drawing.Size(300, 214);
			this.clbDonationType.TabIndex = 3;
			this.clbDonationType.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Width = 270;
			// 
			// btnSelectAllRestrictions
			// 
			this.btnSelectAllRestrictions.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllRestrictions.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllRestrictions.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllRestrictions.Image")));
			this.btnSelectAllRestrictions.Location = new System.Drawing.Point(290, 0);
			this.btnSelectAllRestrictions.Name = "btnSelectAllRestrictions";
			this.btnSelectAllRestrictions.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllRestrictions.TabIndex = 2;
			this.btnSelectAllRestrictions.Click += new System.EventHandler(this.btnSelectAll_Click);
			// 
			// btnDeselectAllRestrictions
			// 
			this.btnDeselectAllRestrictions.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllRestrictions.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllRestrictions.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllRestrictions.Image")));
			this.btnDeselectAllRestrictions.Location = new System.Drawing.Point(274, 0);
			this.btnDeselectAllRestrictions.Name = "btnDeselectAllRestrictions";
			this.btnDeselectAllRestrictions.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllRestrictions.TabIndex = 1;
			this.btnDeselectAllRestrictions.Click += new System.EventHandler(this.btnDeselectAll_Click);
			// 
			// pageUnitStatus
			// 
			this.pageUnitStatus.Controls.Add(this.grpUnitStatus);
			this.pageUnitStatus.Location = new System.Drawing.Point(4, 42);
			this.pageUnitStatus.Name = "pageUnitStatus";
			this.pageUnitStatus.Size = new System.Drawing.Size(320, 251);
			this.pageUnitStatus.TabIndex = 2;
			this.pageUnitStatus.Text = "Unit Status";
			this.pageUnitStatus.Visible = false;
			// 
			// grpUnitStatus
			// 
			this.grpUnitStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpUnitStatus.Controls.Add(this.clbUnitStatuses);
			this.grpUnitStatus.Controls.Add(this.cbBiohazardous);
			this.grpUnitStatus.Controls.Add(this.cbQuarantined);
			this.grpUnitStatus.Controls.Add(this.btnSelectAllUnitStatus);
			this.grpUnitStatus.Controls.Add(this.btnDeselectAllUnitStatus);
			this.grpUnitStatus.Location = new System.Drawing.Point(4, 4);
			this.grpUnitStatus.Name = "grpUnitStatus";
			this.grpUnitStatus.Size = new System.Drawing.Size(312, 242);
			this.grpUnitStatus.TabIndex = 0;
			this.grpUnitStatus.TabStop = false;
			this.grpUnitStatus.Text = "Unit Status";
			// 
			// clbUnitStatuses
			// 
			this.clbUnitStatuses.CheckBoxes = true;
			this.clbUnitStatuses.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnHeader2});
			this.clbUnitStatuses.FullRowSelect = true;
			this.clbUnitStatuses.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.clbUnitStatuses.HideSelection = false;
			this.clbUnitStatuses.Location = new System.Drawing.Point(8, 60);
			this.clbUnitStatuses.MultiSelect = false;
			this.clbUnitStatuses.Name = "clbUnitStatuses";
			this.clbUnitStatuses.Size = new System.Drawing.Size(300, 184);
			this.clbUnitStatuses.Sorting = System.Windows.Forms.SortOrder.Ascending;
			this.clbUnitStatuses.TabIndex = 5;
			this.clbUnitStatuses.View = System.Windows.Forms.View.Details;
			this.clbUnitStatuses.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.clbUnitStatuses_ItemCheck);
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Status";
			this.columnHeader2.Width = 270;
			// 
			// cbBiohazardous
			// 
			this.cbBiohazardous.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbBiohazardous.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbBiohazardous.Location = new System.Drawing.Point(8, 40);
			this.cbBiohazardous.Name = "cbBiohazardous";
			this.cbBiohazardous.Size = new System.Drawing.Size(296, 20);
			this.cbBiohazardous.TabIndex = 1;
			this.cbBiohazardous.Text = "&Biohazardous";
			// 
			// cbQuarantined
			// 
			this.cbQuarantined.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cbQuarantined.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbQuarantined.Location = new System.Drawing.Point(8, 20);
			this.cbQuarantined.Name = "cbQuarantined";
			this.cbQuarantined.Size = new System.Drawing.Size(296, 20);
			this.cbQuarantined.TabIndex = 0;
			this.cbQuarantined.Text = "&Quarantined";
			// 
			// btnSelectAllUnitStatus
			// 
			this.btnSelectAllUnitStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllUnitStatus.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllUnitStatus.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllUnitStatus.Image")));
			this.btnSelectAllUnitStatus.Location = new System.Drawing.Point(290, 0);
			this.btnSelectAllUnitStatus.Name = "btnSelectAllUnitStatus";
			this.btnSelectAllUnitStatus.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllUnitStatus.TabIndex = 4;
			this.btnSelectAllUnitStatus.Click += new System.EventHandler(this.btnSelectAll_Click);
			// 
			// btnDeselectAllUnitStatus
			// 
			this.btnDeselectAllUnitStatus.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllUnitStatus.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllUnitStatus.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllUnitStatus.Image")));
			this.btnDeselectAllUnitStatus.Location = new System.Drawing.Point(274, 0);
			this.btnDeselectAllUnitStatus.Name = "btnDeselectAllUnitStatus";
			this.btnDeselectAllUnitStatus.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllUnitStatus.TabIndex = 3;
			this.btnDeselectAllUnitStatus.Click += new System.EventHandler(this.btnDeselectAll_Click);
			// 
			// pageDateRange
			// 
			this.pageDateRange.Controls.Add(this.grpDateRange);
			this.pageDateRange.Controls.Add(this.grpUnitExpiration);
			this.pageDateRange.Location = new System.Drawing.Point(4, 42);
			this.pageDateRange.Name = "pageDateRange";
			this.pageDateRange.Size = new System.Drawing.Size(320, 251);
			this.pageDateRange.TabIndex = 6;
			this.pageDateRange.Text = "Date Range";
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Controls.Add(this.cbStartDate);
			this.grpDateRange.Controls.Add(this.cbEndDate);
			this.grpDateRange.Enabled = false;
			this.grpDateRange.Location = new System.Drawing.Point(4, 84);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(312, 76);
			this.grpDateRange.TabIndex = 5;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Final Disposition Date Range";
			// 
			// cbStartDate
			// 
			this.cbStartDate.Location = new System.Drawing.Point(12, 20);
			this.cbStartDate.Name = "cbStartDate";
			this.cbStartDate.Size = new System.Drawing.Size(140, 20);
			this.cbStartDate.TabIndex = 1;
			this.cbStartDate.Text = "Disposition &Start Date";
			this.cbStartDate.CheckedChanged += new System.EventHandler(this.cbStartDate_CheckedChanged);
			// 
			// cbEndDate
			// 
			this.cbEndDate.Location = new System.Drawing.Point(12, 44);
			this.cbEndDate.Name = "cbEndDate";
			this.cbEndDate.Size = new System.Drawing.Size(140, 20);
			this.cbEndDate.TabIndex = 3;
			this.cbEndDate.Text = "Disposition &End Date";
			this.cbEndDate.CheckedChanged += new System.EventHandler(this.cbEndDate_CheckedChanged);
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CustomFormat = "";
			this.dtpStartDate.Enabled = false;
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(148, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(112, 20);
			this.dtpStartDate.TabIndex = 0;
			this.dtpStartDate.EnabledChanged += new System.EventHandler(this.dtpStartDate_EnabledChanged);
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CustomFormat = "";
			this.dtpEndDate.Enabled = false;
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(148, 44);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(112, 20);
			this.dtpEndDate.TabIndex = 2;
			this.dtpEndDate.EnabledChanged += new System.EventHandler(this.dtpEndDate_EnabledChanged);
			// 
			// grpUnitExpiration
			// 
			this.grpUnitExpiration.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpUnitExpiration.Controls.Add(this.cbUnitExpiresBefore);
			this.grpUnitExpiration.Controls.Add(this.cbUnitExpiresAfter);
			this.grpUnitExpiration.Controls.Add(this.dtpUntExpiresBefore);
			this.grpUnitExpiration.Controls.Add(this.dtpUnitExpiresAfter);
			this.grpUnitExpiration.Location = new System.Drawing.Point(4, 4);
			this.grpUnitExpiration.Name = "grpUnitExpiration";
			this.grpUnitExpiration.Size = new System.Drawing.Size(312, 76);
			this.grpUnitExpiration.TabIndex = 4;
			this.grpUnitExpiration.TabStop = false;
			this.grpUnitExpiration.Text = "Unit Expiration";
			// 
			// cbUnitExpiresBefore
			// 
			this.cbUnitExpiresBefore.Location = new System.Drawing.Point(12, 20);
			this.cbUnitExpiresBefore.Name = "cbUnitExpiresBefore";
			this.cbUnitExpiresBefore.Size = new System.Drawing.Size(108, 20);
			this.cbUnitExpiresBefore.TabIndex = 1;
			this.cbUnitExpiresBefore.Text = "Expires &Before";
			this.cbUnitExpiresBefore.CheckedChanged += new System.EventHandler(this.cbUnitExpiresBefore_CheckedChanged);
			// 
			// cbUnitExpiresAfter
			// 
			this.cbUnitExpiresAfter.Location = new System.Drawing.Point(12, 44);
			this.cbUnitExpiresAfter.Name = "cbUnitExpiresAfter";
			this.cbUnitExpiresAfter.Size = new System.Drawing.Size(104, 20);
			this.cbUnitExpiresAfter.TabIndex = 3;
			this.cbUnitExpiresAfter.Text = "Expires &After";
			this.cbUnitExpiresAfter.CheckedChanged += new System.EventHandler(this.cbUnitExpiresAfter_CheckedChanged);
			// 
			// dtpUntExpiresBefore
			// 
			this.dtpUntExpiresBefore.CustomFormat = "";
			this.dtpUntExpiresBefore.Enabled = false;
			this.dtpUntExpiresBefore.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpUntExpiresBefore.Location = new System.Drawing.Point(148, 20);
			this.dtpUntExpiresBefore.Name = "dtpUntExpiresBefore";
			this.dtpUntExpiresBefore.Size = new System.Drawing.Size(112, 20);
			this.dtpUntExpiresBefore.TabIndex = 0;
			this.dtpUntExpiresBefore.EnabledChanged += new System.EventHandler(this.dtpUntExpiresBefore_EnabledChanged);
			// 
			// dtpUnitExpiresAfter
			// 
			this.dtpUnitExpiresAfter.CustomFormat = "";
			this.dtpUnitExpiresAfter.Enabled = false;
			this.dtpUnitExpiresAfter.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpUnitExpiresAfter.Location = new System.Drawing.Point(148, 44);
			this.dtpUnitExpiresAfter.Name = "dtpUnitExpiresAfter";
			this.dtpUnitExpiresAfter.Size = new System.Drawing.Size(112, 20);
			this.dtpUnitExpiresAfter.TabIndex = 2;
			this.dtpUnitExpiresAfter.EnabledChanged += new System.EventHandler(this.dtpUnitExpiresAfter_EnabledChanged);
			// 
			// pageABORh
			// 
			this.pageABORh.Controls.Add(this.grpABORh);
			this.pageABORh.Location = new System.Drawing.Point(4, 42);
			this.pageABORh.Name = "pageABORh";
			this.pageABORh.Size = new System.Drawing.Size(320, 251);
			this.pageABORh.TabIndex = 1;
			this.pageABORh.Text = "ABO/Rh";
			this.pageABORh.Visible = false;
			// 
			// grpABORh
			// 
			this.grpABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpABORh.Controls.Add(this.clbABORh);
			this.grpABORh.Controls.Add(this.btnSelectAllABORh);
			this.grpABORh.Controls.Add(this.btnDeselectAllABORh);
			this.grpABORh.Location = new System.Drawing.Point(4, 4);
			this.grpABORh.Name = "grpABORh";
			this.grpABORh.Size = new System.Drawing.Size(312, 242);
			this.grpABORh.TabIndex = 0;
			this.grpABORh.TabStop = false;
			this.grpABORh.Text = "ABO/Rh";
			// 
			// clbABORh
			// 
			this.clbABORh.CheckBoxes = true;
			this.clbABORh.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					   this.columnHeader5});
			this.clbABORh.FullRowSelect = true;
			this.clbABORh.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.clbABORh.HideSelection = false;
			this.clbABORh.Location = new System.Drawing.Point(8, 20);
			this.clbABORh.MultiSelect = false;
			this.clbABORh.Name = "clbABORh";
			this.clbABORh.Size = new System.Drawing.Size(300, 214);
			this.clbABORh.TabIndex = 3;
			this.clbABORh.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Width = 270;
			// 
			// btnSelectAllABORh
			// 
			this.btnSelectAllABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllABORh.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllABORh.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllABORh.Image")));
			this.btnSelectAllABORh.Location = new System.Drawing.Point(290, 0);
			this.btnSelectAllABORh.Name = "btnSelectAllABORh";
			this.btnSelectAllABORh.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllABORh.TabIndex = 2;
			this.btnSelectAllABORh.Click += new System.EventHandler(this.btnSelectAll_Click);
			// 
			// btnDeselectAllABORh
			// 
			this.btnDeselectAllABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllABORh.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllABORh.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllABORh.Image")));
			this.btnDeselectAllABORh.Location = new System.Drawing.Point(274, 0);
			this.btnDeselectAllABORh.Name = "btnDeselectAllABORh";
			this.btnDeselectAllABORh.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllABORh.TabIndex = 1;
			this.btnDeselectAllABORh.Click += new System.EventHandler(this.btnDeselectAll_Click);
			// 
			// pageProductMods
			// 
			this.pageProductMods.Controls.Add(this.grpProductMods);
			this.pageProductMods.Location = new System.Drawing.Point(4, 42);
			this.pageProductMods.Name = "pageProductMods";
			this.pageProductMods.Size = new System.Drawing.Size(320, 251);
			this.pageProductMods.TabIndex = 3;
			this.pageProductMods.Text = "Product Attributes";
			this.pageProductMods.Visible = false;
			// 
			// grpProductMods
			// 
			this.grpProductMods.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpProductMods.Controls.Add(this.clbAttributes);
			this.grpProductMods.Controls.Add(this.btnSelectAllProductMods);
			this.grpProductMods.Controls.Add(this.btnDeselectAllProductMods);
			this.grpProductMods.Location = new System.Drawing.Point(4, 4);
			this.grpProductMods.Name = "grpProductMods";
			this.grpProductMods.Size = new System.Drawing.Size(312, 242);
			this.grpProductMods.TabIndex = 0;
			this.grpProductMods.TabStop = false;
			this.grpProductMods.Text = "Product Attributes";
			// 
			// clbAttributes
			// 
			this.clbAttributes.CheckBoxes = true;
			this.clbAttributes.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							this.columnHeader4});
			this.clbAttributes.FullRowSelect = true;
			this.clbAttributes.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.clbAttributes.HideSelection = false;
			this.clbAttributes.Location = new System.Drawing.Point(8, 20);
			this.clbAttributes.MultiSelect = false;
			this.clbAttributes.Name = "clbAttributes";
			this.clbAttributes.Size = new System.Drawing.Size(300, 214);
			this.clbAttributes.TabIndex = 3;
			this.clbAttributes.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Width = 270;
			// 
			// btnSelectAllProductMods
			// 
			this.btnSelectAllProductMods.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllProductMods.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllProductMods.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllProductMods.Image")));
			this.btnSelectAllProductMods.Location = new System.Drawing.Point(290, 0);
			this.btnSelectAllProductMods.Name = "btnSelectAllProductMods";
			this.btnSelectAllProductMods.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllProductMods.TabIndex = 2;
			this.btnSelectAllProductMods.Click += new System.EventHandler(this.btnSelectAll_Click);
			// 
			// btnDeselectAllProductMods
			// 
			this.btnDeselectAllProductMods.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllProductMods.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllProductMods.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllProductMods.Image")));
			this.btnDeselectAllProductMods.Location = new System.Drawing.Point(274, 0);
			this.btnDeselectAllProductMods.Name = "btnDeselectAllProductMods";
			this.btnDeselectAllProductMods.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllProductMods.TabIndex = 1;
			this.btnDeselectAllProductMods.Click += new System.EventHandler(this.btnDeselectAll_Click);
			// 
			// pageDivision
			// 
			this.pageDivision.Controls.Add(this.grpDivisions);
			this.pageDivision.Location = new System.Drawing.Point(4, 42);
			this.pageDivision.Name = "pageDivision";
			this.pageDivision.Size = new System.Drawing.Size(320, 251);
			this.pageDivision.TabIndex = 7;
			this.pageDivision.Text = "Division";
			// 
			// grpDivisions
			// 
			this.grpDivisions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDivisions.Controls.Add(this.divisionList);
			this.grpDivisions.Controls.Add(this.btnSelectAllDivisions);
			this.grpDivisions.Controls.Add(this.btnDeselectAllDivisions);
			this.grpDivisions.Location = new System.Drawing.Point(4, 4);
			this.grpDivisions.Name = "grpDivisions";
			this.grpDivisions.Size = new System.Drawing.Size(312, 242);
			this.grpDivisions.TabIndex = 1;
			this.grpDivisions.TabStop = false;
			this.grpDivisions.Text = "Division(s)";
			// 
			// divisionList
			// 
			this.divisionList.CheckBoxes = true;
			this.divisionList.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						   this.DivisionName});
			this.divisionList.FullRowSelect = true;
			this.divisionList.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
			this.divisionList.HideSelection = false;
			this.divisionList.Location = new System.Drawing.Point(8, 20);
			this.divisionList.MultiSelect = false;
			this.divisionList.Name = "divisionList";
			this.divisionList.Size = new System.Drawing.Size(300, 214);
			this.divisionList.TabIndex = 4;
			this.divisionList.View = System.Windows.Forms.View.Details;
			// 
			// DivisionName
			// 
			this.DivisionName.Text = "Division";
			this.DivisionName.Width = 270;
			// 
			// btnSelectAllDivisions
			// 
			this.btnSelectAllDivisions.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSelectAllDivisions.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnSelectAllDivisions.Image = ((System.Drawing.Image)(resources.GetObject("btnSelectAllDivisions.Image")));
			this.btnSelectAllDivisions.Location = new System.Drawing.Point(290, 0);
			this.btnSelectAllDivisions.Name = "btnSelectAllDivisions";
			this.btnSelectAllDivisions.Size = new System.Drawing.Size(16, 16);
			this.btnSelectAllDivisions.TabIndex = 2;
			this.btnSelectAllDivisions.Click += new System.EventHandler(this.btnSelectAll_Click);
			// 
			// btnDeselectAllDivisions
			// 
			this.btnDeselectAllDivisions.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDeselectAllDivisions.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDeselectAllDivisions.Image = ((System.Drawing.Image)(resources.GetObject("btnDeselectAllDivisions.Image")));
			this.btnDeselectAllDivisions.Location = new System.Drawing.Point(274, 0);
			this.btnDeselectAllDivisions.Name = "btnDeselectAllDivisions";
			this.btnDeselectAllDivisions.Size = new System.Drawing.Size(16, 16);
			this.btnDeselectAllDivisions.TabIndex = 1;
			this.btnDeselectAllDivisions.Click += new System.EventHandler(this.btnDeselectAll_Click);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(236, 341);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 1;
			this.btnOK.Text = "&OK";
			// 
			// timer1
			// 
			this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// DlgBloodAvailabilitySearch
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(392, 366);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.tabParamters);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.hlphelpChm.SetHelpKeyword(this, "Blood_Availability.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
		
			this.MinimumSize = new System.Drawing.Size(400, 400);
			this.Name = "DlgBloodAvailabilitySearch";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Blood Availability Report";
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.tabParamters, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.tabParamters.ResumeLayout(false);
			this.pageProductType.ResumeLayout(false);
			this.grpProductType.ResumeLayout(false);
			this.pageAntigens.ResumeLayout(false);
			this.grpAntigens.ResumeLayout(false);
			this.pageDonationType.ResumeLayout(false);
			this.grpDonationType.ResumeLayout(false);
			this.pageUnitStatus.ResumeLayout(false);
			this.grpUnitStatus.ResumeLayout(false);
			this.pageDateRange.ResumeLayout(false);
			this.grpDateRange.ResumeLayout(false);
			this.grpUnitExpiration.ResumeLayout(false);
			this.pageABORh.ResumeLayout(false);
			this.grpABORh.ResumeLayout(false);
			this.pageProductMods.ResumeLayout(false);
			this.grpProductMods.ResumeLayout(false);
			this.pageDivision.ResumeLayout(false);
			this.grpDivisions.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Methods

		/// <summary>
		/// If the single division radio button was checked on the report type screen,
		/// we need to default to single division in this screen.
		/// </summary>
		private void CheckUsersDivision()
		{
			foreach(ListViewItem lvi in divisionList.Items)
			{
				if (Common.LogonUser.LogonUserDivisionCode == lvi.Tag.ToString())
				{
					lvi.Checked = true;
					break;
				}
			}
		}

		/// <summary>
		/// If the all divisions radio button was checked on the report type screen,
		/// we need to check all divisions in this screen by default.
		/// </summary>
		private void CheckAllDivisions()
		{
			foreach(ListViewItem lvi in divisionList.Items)
			{
				lvi.Checked = true;
			}
		}

		/// <summary>
		/// This method populates the ListViews contained within the form
		/// with check boxes used to create the custom search parameters.
		/// </summary>
		private void LoadCheckBoxes()
		{
			// Load the valid divisions.			
			foreach( BOL.Division _div in ThisUser.DivisionsAndRoles.EffectiveDivisions )
			{	
				ListViewItem _lvi = new ListViewItem();

				_lvi.Text = _div.DivisionName;
				_lvi.Tag = _div.DivisionCode;
			
				this.divisionList.Items.Add( _lvi );
			}
			// Populate the antigens list.			
			DataTable datatable = BOL.Antigen.GetAntigenLookupList();
			foreach(DataRow div in datatable.Rows)
			{
				ListViewItem lvi=new ListViewItem(div[Common.VbecsTables.AntigenType.AntigenTypeId].ToString());
				lvi.Text=div[Common.VbecsTables.AntigenType.AntigenTypeName].ToString();
				lvi.Tag=div[Common.VbecsTables.AntigenType.AntigenTypeId].ToString();

				this.clbAntigens.Items.Add(lvi);
			}
			
			// Populate the component class list view.
			datatable=BOL.BloodProduct.GetComponentClassValues();
			foreach(DataRow div in datatable.Rows)
			{
				// BR_49.09
				if(div[Common.VbecsTables.ComponentClass.ComponentClassId].ToString()!="9")
				{
					ListViewItem lvi=new ListViewItem(div[Common.VbecsTables.ComponentClass.ComponentClassId].ToString());
					lvi.Text=div[Common.VbecsTables.ComponentClass.ComponentClassName].ToString();
					lvi.Tag=div[Common.VbecsTables.ComponentClass.ComponentClassId].ToString();
	
					this.clbProductType.Items.Add(lvi);
				}
			}
			// Populate the Unit Status List View
			datatable=BOL.ReferenceData.GetUnitStatusList();
			foreach(DataRow div in datatable.Rows)
			{
				// BR_49.09
				//if(div[Common.VbecsTables.UnitStatus.UnitStatusCode].ToString()!="D" && div[Common.VbecsTables.UnitStatus.UnitStatusCode].ToString()!="M" && div[Common.VbecsTables.UnitStatus.UnitStatusCode].ToString()!="T" &&div[Common.VbecsTables.UnitStatus.UnitStatusCode].ToString()!="X")
				if(div[Common.VbecsTables.UnitStatus.UnitStatusCode].ToString()!="T")
				{
					ListViewItem lvi=new ListViewItem(div[Common.VbecsTables.UnitStatus.UnitStatusCode].ToString());
					lvi.Text=div[Common.VbecsTables.UnitStatus.UnitStatusText].ToString();
					lvi.Tag=div[Common.VbecsTables.UnitStatus.UnitStatusCode].ToString();
					if(div[Common.VbecsTables.UnitStatus.UnitStatusCode].ToString()!="D" && div[Common.VbecsTables.UnitStatus.UnitStatusCode].ToString()!="M" && div[Common.VbecsTables.UnitStatus.UnitStatusCode].ToString()!="X")
					{
						//check non-final statuses by default
						lvi.Checked = true;
					}
					this.clbUnitStatuses.Items.Add(lvi);
				}
			}
			//Populate the Product Attribute list view
			datatable = BOL.ReferenceData.GetProductModificationList();
			foreach(DataRow att in datatable.Rows)
			{
				ListViewItem lvi = new ListViewItem(att[Common.VbecsTables.ProductModification.ProductModificationText].ToString());
				lvi.Tag = att[Common.VbecsTables.ProductModification.ProductModificationCode].ToString();
				this.clbAttributes.Items.Add(lvi);
			}
			//Populate the Donation Type list view
			AddDonationTypeToList('N',"Allogeneic");
			AddDonationTypeToList('A',"Autologous");
			AddDonationTypeToList('D',"Directed");
			//Populate the ABO/Rh list view
			AddAboRhToList(Common.ABO.O,Common.RH.Positive);
			AddAboRhToList(Common.ABO.A,Common.RH.Positive);
			AddAboRhToList(Common.ABO.B,Common.RH.Positive);
			AddAboRhToList(Common.ABO.AB,Common.RH.Positive);
			//
			AddAboRhToList(Common.ABO.O,Common.RH.Negative);
			AddAboRhToList(Common.ABO.A,Common.RH.Negative);
			AddAboRhToList(Common.ABO.B,Common.RH.Negative);
			AddAboRhToList(Common.ABO.AB,Common.RH.Negative);
			//
			AddAboRhToList(Common.ABO.O,Common.RH.Blank);
			AddAboRhToList(Common.ABO.A,Common.RH.Blank);
			AddAboRhToList(Common.ABO.B,Common.RH.Blank);
			AddAboRhToList(Common.ABO.AB,Common.RH.Blank);
			//
			AddAboRhToList(Common.ABO.Mx,Common.RH.Positive);
			AddAboRhToList(Common.ABO.Mx,Common.RH.Negative);
			//
			AddAboRhToList(Common.ABO.O,Common.RH.PooledRH);
			AddAboRhToList(Common.ABO.A,Common.RH.PooledRH);
			AddAboRhToList(Common.ABO.B,Common.RH.PooledRH);
			AddAboRhToList(Common.ABO.AB,Common.RH.PooledRH);
			//
			AddAboRhToList(Common.ABO.Mx,Common.RH.PooledRH);
		}

		private void AddDonationTypeToList(char donationTypeCode, string donationType)
		{
			ListViewItem lviDT = new ListViewItem(donationType);
			lviDT.Tag = donationTypeCode;
			this.clbDonationType.Items.Add(lviDT);
		}

		private void AddAboRhToList(Common.ABO abo, Common.RH rh)
		{
			BOL.AboRh aborh = new BOL.AboRh(abo,rh);
			ListViewItem lviAboRh = new ListViewItem(aborh.AboRHText);
			lviAboRh.Tag = aborh.AboRHText;
			this.clbABORh.Items.Add(lviAboRh);
		}

		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC049.DlgBloodAvailabilitySearch());
			//
			this.dtpUnitExpiresAfter.CustomFormat = " ";
			this.dtpUntExpiresBefore.CustomFormat = " ";
			this.dtpStartDate.CustomFormat = " ";
			this.dtpEndDate.CustomFormat = " ";
			//set current date value based on the division time zone
			System.DateTime _currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime().Date.AddDays(-1);
			this.dtpUntExpiresBefore.Value = _currentDate;
			this.dtpUnitExpiresAfter.Value = _currentDate;
			this.dtpStartDate.Value = _currentDate;
			this.dtpEndDate.Value = _currentDate;
			//
			this.SetThisToolTip(this.btnOK,Common.StrRes.Tooltips.Common.OKToContinue());
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			//
			this.SetThisToolTip(this.btnDeselectAllABORh,Common.StrRes.Tooltips.Common.DeselectAll());
			this.SetThisToolTip(this.btnDeselectAllAntigens,Common.StrRes.Tooltips.Common.DeselectAll());
			this.SetThisToolTip(this.btnDeselectAllDivisions,Common.StrRes.Tooltips.Common.DeselectAll());
			this.SetThisToolTip(this.btnDeselectAllProductMods,Common.StrRes.Tooltips.Common.DeselectAll());
			this.SetThisToolTip(this.btnDeselectAllProductTypes,Common.StrRes.Tooltips.Common.DeselectAll());
			this.SetThisToolTip(this.btnDeselectAllRestrictions,Common.StrRes.Tooltips.Common.DeselectAll());
			this.SetThisToolTip(this.btnDeselectAllUnitStatus,Common.StrRes.Tooltips.Common.DeselectAll());
			//
			this.SetThisToolTip(this.btnSelectAllABORh,Common.StrRes.Tooltips.Common.SelectAll());
			this.SetThisToolTip(this.btnSelectAllAntigens,Common.StrRes.Tooltips.Common.SelectAll());
			this.SetThisToolTip(this.btnSelectAllDivisions,Common.StrRes.Tooltips.Common.SelectAll());
			this.SetThisToolTip(this.btnSelectAllProductMods,Common.StrRes.Tooltips.Common.SelectAll());
			this.SetThisToolTip(this.btnSelectAllProductTypes,Common.StrRes.Tooltips.Common.SelectAll());
			this.SetThisToolTip(this.btnSelectAllRestrictions,Common.StrRes.Tooltips.Common.SelectAll());
			this.SetThisToolTip(this.btnSelectAllUnitStatus,Common.StrRes.Tooltips.Common.SelectAll());
		}
			
		private void ClearCheckedList(System.Windows.Forms.ListView view)
		{
			// Iterate through the list view passed in and set the check
			// state of all the items to false.
			for(int i=0; i<view.Items.Count; i++)
				view.Items[i].Checked=false;
		}

		private void CheckCheckedList(System.Windows.Forms.ListView view)
		{
			// Iterate through the list view passed in and set the check
			// state of all the items to true.
			for(int i=0; i<view.Items.Count; i++)
				view.Items[i].Checked=true;
		}

		/// <summary>
		/// Private method to search entries in listview and ensure that values matching
		/// text entered are visible to the user.
		/// </summary>
		private void DisplayMatchingAntigen()
		{
			foreach(ListViewItem lviAntigen in clbAntigens.Items)
			{
				//find exact match first
				if (lviAntigen.Text == txtRBCAntigens.Text)
				{
					lviAntigen.Selected = true;
					lviAntigen.EnsureVisible();
					break;
				}
				//find partial match
				if (lviAntigen.Text.StartsWith(txtRBCAntigens.Text))
				{
					lviAntigen.Selected = true;
					lviAntigen.EnsureVisible();
					break;
				}
			}
		}

		#endregion

		#region Properties

		/// <summary>
		/// Get ComponentClasses
		/// </summary>
		public ArrayList ComponentClasses
		{
			get
			{
				// Return all checked component classes
				ArrayList _list=new ArrayList();
				for(int i=0; i<this.clbProductType.CheckedItems.Count; i++)
				{
					_list.Add(clbProductType.CheckedItems[i].Tag.ToString());
				}
				return _list;
			}
		}
		
		/// <summary>
		/// Get AboRh
		/// </summary>
		public ArrayList AboRh
		{
			get
			{
				// Return all checked blood types
				ArrayList _list=new ArrayList();
				for(int i=0; i<this.clbABORh.CheckedItems.Count; i++)
				{
					_list.Add(this.clbABORh.CheckedItems[i].Tag.ToString());
				}
				return _list;
			}
		}

		/// <summary>
		/// Get DonationTypes
		/// </summary>
		public ArrayList DonationTypes
		{
			get
			{
				// Return all checked donation types
				ArrayList _list=new ArrayList();
				for(int i=0; i<this.clbDonationType.CheckedItems.Count; i++)
				{
					_list.Add(this.clbDonationType.CheckedItems[i].Tag.ToString());
				}
				return _list;
			}
		}

		/// <summary>
		/// Get UnitStatuses
		/// </summary>
		public ArrayList UnitStatuses
		{
			get
			{
				// Return all checked Unit Statuses
				ArrayList _list=new ArrayList();
				for(int i=0; i<this.clbUnitStatuses.CheckedItems.Count; i++)
				{
					_list.Add(this.clbUnitStatuses.CheckedItems[i].Tag.ToString());
				}				
				return _list;
			}
		}

		/// <summary>
		/// Get UnitAntigens
		/// </summary>
		public ArrayList UnitAntigens
		{
			get
			{
				// Return all checked antigens
				ArrayList _list=new ArrayList();
				for(int i=0; i<this.clbAntigens.CheckedItems.Count; i++)
				{
					_list.Add(this.clbAntigens.CheckedItems[i].Tag.ToString());
				}
				return _list;
			}
		}

		/// <summary>
		/// Get ProductAttributes
		/// </summary>
		public ArrayList ProductAttributes
		{
			get
			{
				// Return all checked attributes
				ArrayList _list=new ArrayList();
				for(int i=0; i<this.clbAttributes.CheckedItems.Count; i++)
				{
					_list.Add(this.clbAttributes.CheckedItems[i].Tag.ToString());
				}
				return _list;
			}
		}

		/// <summary>
		/// Get Divisions
		/// </summary>
		public ArrayList Divisions
		{
			get
			{
				// Return all checked divisions.
				ArrayList _list=new ArrayList();
				for(int i=0; i<this.divisionList.CheckedItems.Count; i++)
				{
					_list.Add(this.divisionList.CheckedItems[i].Tag.ToString());
				}
				return _list;
			}
		}

		/// <summary>
		/// Get ExpirationDateBefore
		/// </summary>
		public DateTime ExpirationDateBefore
		{
			get
			{
				// Return the date selected, if one is selected.
				if(this.cbUnitExpiresBefore.Checked)
					return this.dtpUntExpiresBefore.Value;
				else
					// Return the default date.
					return DateTime.Parse("12/31/9999");
			}
		}

		/// <summary>
		/// Get ExpirationDateAfter
		/// </summary>
		public DateTime ExpirationDateAfter
		{
			get
			{
				// Return the expires after date if one is selected.
				if(this.cbUnitExpiresAfter.Checked)
					return this.dtpUnitExpiresAfter.Value;
				else
					// Return the default date.
					return DateTime.Parse("1/1/1900");
			}
		}

		/// <summary>
		/// Get StartDate
		/// </summary>
		public DateTime StartDate
		{
			get
			{
				// Return the date selected, if one is selected.
				if(this.cbStartDate.Checked)
					return this.dtpStartDate.Value;
				else
					// Return the default date.
					return DateTime.Parse("1/1/1900");
			}
		}

		/// <summary>
		/// Get EndDate
		/// </summary>
		public DateTime EndDate
		{
			get
			{
				// Return the expires after date if one is selected.
				if(this.cbEndDate.Checked)
					return this.dtpEndDate.Value;
				else
					// Return the default date.
					return DateTime.Parse("12/31/9999");
			}
		}

		/// <summary>
		/// Get CmvTesting
		/// </summary>
		public bool CmvTesting
		{
			get
			{
				// Returned the checked state
				return this.cbCMVNegative.Checked;
			}
		}

		/// <summary>
		/// Get SickleCellTesting
		/// </summary>
		public bool SickleCellTesting
		{
			get
			{
				// Returned the checked state
				return this.cbSickleCellNegative.Checked;
			}
		}

		/// <summary>
		/// Get Biohazardous
		/// </summary>
		public bool Biohazardous
		{
			get
			{
				// Returned the checked state
				return this.cbBiohazardous.Checked;
			}
		}

		/// <summary>
		/// Get Quarantined
		/// </summary>
		public bool Quarantined
		{
			get
			{
				// Returned the checked state
				return this.cbQuarantined.Checked;
			}
		}

		#endregion

		# region Action Events
		
		private void btnDeselectAll_Click(object sender, System.EventArgs e)
		{
			// Use the name of the radio button to determine 
			// which one was clicked.
			// Each case calls the ClearCheckedList function, 
			// passing the appropriate ListView to iterate
			// through.
			switch(((Button)sender).Name.ToString())
			{
				case "btnDeselectAllProductTypes":
					this.ClearCheckedList(this.clbProductType);
					break;
				case "btnDeselectAllProductMods":
					this.ClearCheckedList(this.clbAttributes);
					break;
				case "btnDeselectAllABORh":
					this.ClearCheckedList(this.clbABORh);
					break;
				case "btnDeselectAllAntigens":
					// Set the SickleCellNegative state to unchecked.
					this.cbSickleCellNegative.Checked=false;
					// Set the CMVNegative state to unchecked.
					this.cbCMVNegative.Checked=false;
					this.ClearCheckedList(this.clbAntigens);
					break;
				case "btnDeselectAllDivisions":
					this.ClearCheckedList(this.divisionList);
					break;
				case "btnDeselectAllRestrictions":
					this.ClearCheckedList(this.clbDonationType);
					break;
				case "btnDeselectAllUnitStatus":
					// Set the cbQuarantined state to unchecked.
					this.cbQuarantined.Checked=false;
					// Set the cbBiohazardous state to unchecked.
					this.cbBiohazardous.Checked=false;
					this.ClearCheckedList(this.clbUnitStatuses);
					break;
			}
		}

		private void btnSelectAll_Click(object sender, System.EventArgs e)
		{
			// Use the name of the radio button to determine 
			// which one was clicked.
			// Each case calls the CheckCheckedList function, 
			// passing the appropriate ListView to iterate
			// through.
			switch(((Button)sender).Name.ToString())
			{
				case "btnSelectAllProductTypes":
					this.CheckCheckedList(this.clbProductType);
					break;
				case "btnSelectAllProductMods":
					this.CheckCheckedList(this.clbAttributes);
					break;
				case "btnSelectAllABORh":
					this.CheckCheckedList(this.clbABORh);
					break;
				case "btnSelectAllAntigens":
					// Set the checked sate of cbSickleCellNegative to true.
					this.cbSickleCellNegative.Checked=true;
					// Set the checked sate of cbCMVNegative to true.
					this.cbCMVNegative.Checked=true;
					this.CheckCheckedList(this.clbAntigens);
					break;
				case "btnSelectAllDivisions":
					this.CheckCheckedList(this.divisionList);
					break;
				case "btnSelectAllRestrictions":
					this.CheckCheckedList(this.clbDonationType);
					break;
				case "btnSelectAllUnitStatus":
					// Set the checked sate of cbQuarantined to true.
					this.cbQuarantined.Checked=true;
					// Set the checked sate of cbBiohazardous to true.
					this.cbBiohazardous.Checked=true;
					this.CheckCheckedList(this.clbUnitStatuses);
					break;
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void cbUnitExpiresBefore_CheckedChanged(object sender, System.EventArgs e)
		{
			this.dtpUntExpiresBefore.Enabled = (this.cbUnitExpiresBefore.Checked);
		}

		private void cbUnitExpiresAfter_CheckedChanged(object sender, System.EventArgs e)
		{
			this.dtpUnitExpiresAfter.Enabled = (this.cbUnitExpiresAfter.Checked);
		}

		private void dtpUnitExpiresAfter_EnabledChanged(object sender, System.EventArgs e)
		{
			if (this.dtpUnitExpiresAfter.Enabled)
			{
				this.dtpUnitExpiresAfter.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
			else
			{
				this.dtpUnitExpiresAfter.CustomFormat = " ";
			}
		}

		private void dtpUntExpiresBefore_EnabledChanged(object sender, System.EventArgs e)
		{
			if (this.dtpUntExpiresBefore.Enabled)
			{
				this.dtpUntExpiresBefore.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
			else
			{
				this.dtpUntExpiresBefore.CustomFormat = " ";
			}
		}

		private void cbStartDate_CheckedChanged(object sender, System.EventArgs e)
		{
			this.dtpStartDate.Enabled = (this.cbStartDate.Checked);
		}

		private void cbEndDate_CheckedChanged(object sender, System.EventArgs e)
		{
			this.dtpEndDate.Enabled = (this.cbEndDate.Checked);
		}

		private void dtpEndDate_EnabledChanged(object sender, System.EventArgs e)
		{
			if (this.dtpEndDate.Enabled)
			{
				this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
			else
			{
				this.dtpEndDate.CustomFormat = " ";
			}
		}

		private void dtpStartDate_EnabledChanged(object sender, System.EventArgs e)
		{
			if (this.dtpStartDate.Enabled)
			{
				this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			}
			else
			{
				this.dtpStartDate.CustomFormat = " ";
			}
		}

		private void txtRBCAntigens_TextChanged(object sender, System.EventArgs e)
		{
			//reset timer
			timer1.Enabled = false;
			//
			timer1.Enabled = (txtRBCAntigens.Text.Length > 0);
		}

		private void timer1_Tick(object sender, System.EventArgs e)
		{
			timer1.Enabled = false;
			//
			DisplayMatchingAntigen();
		}

		#endregion

		private void clbUnitStatuses_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			//If a final status is checked/unchecked...
			Common.UnitStatusCode usc = Common.Utility.GetUnitStatusCodeFromString(((ListViewItem)this.clbUnitStatuses.Items[e.Index]).Tag.ToString());
			//
			if ((usc==Common.UnitStatusCode.Discarded)||
				(usc==Common.UnitStatusCode.Modified)||
				(usc==Common.UnitStatusCode.Transferred))
			{
				//Enable date range when checking a final status
				if (e.NewValue == CheckState.Checked)
				{
					this.grpDateRange.Enabled = true;
					return;
				}
				else
				{
					foreach(ListViewItem lvi in this.clbUnitStatuses.CheckedItems)
					{
						if (lvi.Index==e.Index)
						{
							continue;
						}
						//Unchecking a final status, see if there are any others checked
						Common.UnitStatusCode checkUsc = Common.Utility.GetUnitStatusCodeFromString(lvi.Tag.ToString());
						//
						if ((checkUsc==Common.UnitStatusCode.Discarded)||
							(checkUsc==Common.UnitStatusCode.Modified)||
							(checkUsc==Common.UnitStatusCode.Transferred))
						{
							this.grpDateRange.Enabled = true;
							return;
						}
					}
				}
			}
			//
			this.grpDateRange.Enabled = false;
		}

	}
}